from flask import Flask, render_template, request, redirect, url_for, send_file
from flask_login import LoginManager, UserMixin, login_user, login_required, logout_user, current_user
from flask_mail import Mail, Message
from werkzeug.security import generate_password_hash, check_password_hash
from io import BytesIO
import datetime
import weasyprint

app = Flask(__name__)
app.secret_key = 'your_secret_key'

# Dummy user
users = {'admin@example.com': generate_password_hash('password123')}

login_manager = LoginManager()
login_manager.init_app(app)
login_manager.login_view = 'login'

# Email config
app.config['MAIL_SERVER'] = 'smtp.yourdomain.com'
app.config['MAIL_PORT'] = 465
app.config['MAIL_USE_SSL'] = True
app.config['MAIL_USERNAME'] = 'your_email@yourdomain.com'
app.config['MAIL_PASSWORD'] = 'your_password'
mail = Mail(app)

class User(UserMixin):
    def __init__(self, email):
        self.id = email

@login_manager.user_loader
def load_user(user_id):
    if user_id in users:
        return User(user_id)
    return None

@app.route('/', methods=['GET', 'POST'])
def login():
    if request.method == 'POST':
        email = request.form['email']
        password = request.form['password']
        if email in users and check_password_hash(users[email], password):
            user = User(email)
            login_user(user)
            return redirect(url_for('create_invoice'))
        return 'Invalid credentials'
    return render_template('login.html')

@app.route('/logout')
@login_required
def logout():
    logout_user()
    return redirect(url_for('login'))

@app.route('/create_invoice', methods=['GET', 'POST'])
@login_required
def create_invoice():
    if request.method == 'POST':
        dealer_name = request.form['dealer_name']
        dealer_email = request.form['dealer_email']
        customer_name = request.form['customer_name']
        customer_email = request.form['customer_email']
        car_details = request.form['car_details']
        sale_price = float(request.form['sale_price'])
        gst = float(request.form['gst'])
        pst = float(request.form['pst'])
        total_amount = sale_price + gst + pst
        disclaimer = request.form['disclaimer']
        send_to_dealer = 'send_to_dealer' in request.form
        send_to_customer = 'send_to_customer' in request.form
        date = datetime.date.today()

        html = render_template('invoice_template.html',
                               dealer_name=dealer_name,
                               customer_name=customer_name,
                               car_details=car_details,
                               sale_price=sale_price,
                               gst=gst,
                               pst=pst,
                               total_amount=total_amount,
                               disclaimer=disclaimer,
                               date=date)

        pdf = weasyprint.HTML(string=html).write_pdf()

        recipients = []
        if send_to_dealer:
            recipients.append(dealer_email)
        if send_to_customer:
            recipients.append(customer_email)

        if recipients:
            msg = Message('Car Sale Invoice', sender='your_email@yourdomain.com', recipients=recipients)
            msg.body = 'Please find attached your car sale invoice.'
            msg.attach('invoice.pdf', 'application/pdf', pdf)
            mail.send(msg)

        return send_file(BytesIO(pdf), download_name='invoice.pdf', as_attachment=True)

    return render_template('create_invoice.html')

if __name__ == '__main__':
    app.run()
